

#----------------------------------------------------------------#
#### Comparing more than two MEDIANS - Size Variation Index #### 
#----------------------------------------------------------------#

#-----------------------------#
#### Kruskal-Wallis Test ####
#-----------------------------#

#Fig. 5


#Import external data into "SVI"
SVI_dataset <- read.csv("R_SVI.csv", header = T, sep = ";")

#Change from integer into numeric
SVI_dataset$Sites <- as.factor(SVI_dataset$Sites)

SVI_dataset$Sites <- factor(SVI_dataset$Sites,
                           levels = c("Holocene_Italy", "Latnija", "MIS2_Italy", "Sicily"),
                           labels = c("Italy (Holocene)", "Latnija (Holocene)", "Italy (Late Pleistocene)", "Sicily (Late Pleistocene)"))

str(SVI_dataset) #structure of dataframe

#Data visualization (SVI_dataset)

#Make a box-plot of SVI as a function of Site, add all points on top
plot(SVI_dataset$SVI ~ SVI_dataset$Sites, 
     xlab = "Site & Regions (Period)", ylab = "SVI values", 
     pch=20, cex=0, at = c(4,1,3,2)) # cex=0 suppresses outliers - they are shown with the next command

#Store custom positions (based on site & region % Chronology, rather than in alphabetical order, which is the default)
custom_at <- c(4, 1, 3, 2)

#Map the factor levels of 'Sites' to these positions
#This ensures that Site level 1 goes to at=4, level 2 to at=1, etc.
mapped_x <- custom_at[as.numeric(as.factor(SVI_dataset$Sites))]

#Jitter points using the mapped x-values
points(x = jitter(mapped_x, amount = 0.3), 
       y = SVI_dataset$SVI, 
       col = "brown", 
       cex = 1.3, 
       pch = 20)

# Perform the Kruskal-Wallis Test
kruskal.test(SVI_dataset$SVI ~ SVI_dataset$Sites, SVI_dataset)

# Non-parametric posthoc test (many options - make sure p-values are adjusted!)
pairwise.wilcox.test(SVI_dataset$SVI, SVI_dataset$Sites,
                     p.adjust.method = "hochberg")

